 ; Ŀ
 ;   Gnd.lsp - draw the ground grid around a building.                     
 ; 
 (DEFUN C:GND (/ ofset dimscl p1 p3 p2 p4 px1 py1 px2 py2 px3 py3 px4 py4 p1a
                                             p2a p2a1 p2a2 p3A p4a p4a1 p4a2)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   If the ground layer doesn't exist, make it.                           
 ; 
  (if (null (tblsearch "layer" "ground"))
      (command "layer" "new" "ground"
                       "colour" 4 "ground"
                       "ltype" "center" "ground" ""))
  (setvar "clayer" "ground")
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq dimscl (misps))
 ; Ŀ
 ;   Get an offset, if we are in ps scale it down by dimscale.             
 ; 
  (setq ofset 1000)
  (if (= (wasp) 2)
      (setq ofset (/ ofset (getvar "dimscale"))))
 ; Ŀ
 ;   Get two opposite corner points.                                       
 ; 
  (setq p1 (getpoint "\nFirst corner: "))
  (setq p3 (getcorner p1 "\nOpposite corner: "))
 ; Ŀ
 ;   Get X and Y values for each point.                                    
 ; 
  (setq px1 (car p1))
  (setq py1 (cadr p1))
  (setq px3 (car p3))
  (setq py3 (cadr p3))
 ; Ŀ
 ;   Make the other two points, get their X and Y values.                  
 ; 
  (setq P2 (list px1 py3))
  (setq P4 (list px3 py1))
  (setq px2 (car p2))
  (setq py2 (cadr p2))
  (setq px4 (car p4))
  (setq py4 (cadr p4))
 ; Ŀ
 ;   The corners can be picked in four different ways.                     
 ;   1. Lower left and upper right.                                        
 ; 
  (cond ((and (> px3 px1) (> py3 py1))
         (setq P1a (list (- px1 ofset) (- py1 ofset)))   ; diagonal offset
         (setq P2a (list (- px2 ofset) (+ py2 ofset)))   ; diagonal offset
         (setq p2a1 (list px2 (+ py2 ofset)))            ; straight offset 1
         (setq p2a2 (list (- px2 ofset) py2))            ; straight offset 2
         (setq P3a (list (+ px3 ofset) (+ py3 ofset)))   ; etc.
         (setq P4a (list (+ px4 ofset) (- py4 ofset)))
         (setq p4a1 (list px4 (- py4 ofset)))
         (setq p4a2 (list (+ px4 ofset) py4))
         (command "pline" p1a p4a1 "a" "ce" p4 p4a2
                             "line" p3a
                              p2a1 "a" "ce" p2 p2a2
                             "line" "close"))
 ; Ŀ
 ;   The corners can be picked in four different ways.                     
 ;   2. Upper left and lower right.                                        
 ; 
        ((and (> px3 px1) (< py3 py1))
         (setq P1a (list (- px1 ofset) (+ py1 ofset)))
         (setq P2a (list (- px2 ofset) (- py2 ofset)))
         (setq p2a1 (list (- px2 ofset) py2))
         (setq p2a2 (list px2 (- py2 ofset)))
         (setq P3a (list (+ px3 ofset) (- py3 ofset)))
         (setq P4a (list (+ px4 ofset) (+ py4 ofset)))
         (setq p4a1 (list (+ px4 ofset) py4))
         (setq p4a2 (list px4 (+ py4 ofset)))
         (command "pline" p1a p2a1 "a" "ce" p2 p2a2
                             "line" p3a
                              p4a1 "a" "ce" p4 p4a2
                             "line" "close"))
 ; Ŀ
 ;   The corners can be picked in four different ways.                     
 ;   3. Upper right and lower left.                                        
 ; 
        ((and (< px3 px1) (< py3 py1))
         (setq P1a (list (+ px1 ofset) (+ py1 ofset)))
         (setq P2a (list (+ px2 ofset) (- py2 ofset)))
         (setq p2a1 (list px2 (- py2 ofset)))
         (setq p2a2 (list (+ px2 ofset) py2))
         (setq P3a (list (- px3 ofset) (- py3 ofset)))
         (setq P4a (list (- px4 ofset) (+ py4 ofset)))
         (setq p4a1 (list px4 (+ py4 ofset)))
         (setq p4a2 (list (- px4 ofset) py4))
         (command "pline" p1a p4a1 "a" "ce" p4 p4a2
                             "line" p3a
                              p2a1 "a" "ce" p2 p2a2
                             "line" "close"))
 ; Ŀ
 ;   The corners can be picked in four different ways.                     
 ;   4. Lower right and upper left.                                        
 ; 
        ((and (< px3 px1) (> py3 py1))
         (setq P1a (list (+ px1 ofset) (- py1 ofset)))
         (setq P2a (list (+ px2 ofset) (+ py2 ofset)))
         (setq p2a1 (list (+ px2 ofset) py2))
         (setq p2a2 (list px2 (+ py2 ofset)))
         (setq P3a (list (- px3 ofset) (+ py3 ofset)))
         (setq P4a (list (- px4 ofset) (- py4 ofset)))
         (setq p4a1 (list (- px4 ofset) py4))
         (setq p4a2 (list px4 (- py4 ofset)))
         (command "pline" p1a p2a1 "a" "ce" p2 p2a2
                             "line" p3a
                              p4a1 "a" "ce" p4 p4a2
                             "line" "close")))
 ; Ŀ
 ;   Insert ground well and connection blocks.                             
 ; 
  (command ".insert" "groundwell" p1a dimscl "" 0)
  (command ".insert" "groundwell" p3a dimscl "" 0)
  (command ".insert" "groundcon" p1 dimscl "" 0)
  (command ".insert" "groundcon" p3 dimscl "" 0)
 ; Ŀ
 ;   Draw connections to the building.                                     
 ; 
  (command ".arc" p1 "e" p1a "r" 2000)
  (command ".arc" p3 "e" p3a "r" 2000)
 (princ))

(princ)